// 函数转换使用，用于将 FsCommand 调用
window.external = {
  FsCommand: function(param1, param2) {
      if (window.webkit && window.webkit.messageHandlers && window.webkit.messageHandlers.jsBridgeOCHandler) {
          var dict = {"function":param1, "params":param2};
          window.webkit.messageHandlers.jsBridgeOCHandler.postMessage(dict);
      }
  }
};


window.__ssrMeta__ = {
    ssrUrl: "httpa://file.ssr/"
};


// 修复迪士尼团子派对中使用 BroadcastChannel，在旧系统不兼容的问题
if (typeof BroadcastChannel === 'undefined') {
  window.BroadcastChannel = function(channel) {
    var $this = this;
    this.channel = channel;
    this._listeners = [];
      this._storageListener = function(e){
          if (e.storageArea === localStorage && e.key === channel) {
            var data = JSON.parse(e.newValue);
            $this._listeners.forEach(function(listener) {
              listener({ data: data });
            });
          }
        };
      window.addEventListener('storage', this._storageListener);
      };


  window.BroadcastChannel.prototype.postMessage = function(data) {
    localStorage.setItem(this.channel, JSON.stringify(data));
  };


  window.BroadcastChannel.prototype.addEventListener = function(event, listener) {
    if (event === 'message') {
      this._listeners.push(listener);
    }
  };


  window.BroadcastChannel.prototype.close = function() {
      // 移除 storage 事件的监听器
      window.removeEventListener('storage', this._storageListener);
      // 清空监听器列表
      this._listeners = [];
  };
}


// 模拟 navigator.getBattery()
if (typeof navigator.getBattery!=='function') {
    navigator.getBattery = function() {
        return new Promise((resolve) => {
            // 假设全局变量 batteryInfo 存储了从原生代码传递过来的电池信息
            const batteryInfo = window.batteryInfo || {
                level: 1,
                charging: false
            };
            resolve({
                level: batteryInfo.level,
                charging: batteryInfo.charging,
                addEventListener: function(event, callback) {
                    if (event === 'levelchange' || event === 'chargingchange') {
                        // 这里可以添加自定义的监听逻辑，比如通过自定义事件或轮询
                        // 这里简单地使用 setInterval 模拟监听
                        setInterval(() => {
                            callback({
                                target: {
                                    level: batteryInfo.level,
                                    charging: batteryInfo.charging
                                }
                            });
                        }, 1000);
                    }
                }
            });
        });
    };
}


// 新增 updateBatteryInfo 函数
function updateBatteryInfo(level, charging) {
    // 假设你想要更新页面上显示的电池信息，例如修改图片等
    console.log('更新电池信息：level = ' + level + ', charging = ' + charging);
    setStatus(charging, level);
    setLevel(level);
}


// 将 setStatus 函数定义在全局作用域
function setStatus(status, level) {
    level = Math.floor(level * 100);
    if (status) {
        chargStatic = false;
        console.log('设备正在充电');
        document.getElementById('electricity').src='6.png';
    } else {
        console.log('设备未在充电状态');
        chargStatic = true;
    }
}


// 将 setLevel 函数定义在全局作用域
function setLevel(batteryLevel) {
    let level = Math.floor(batteryLevel * 100);
    showEletricity(level, document.getElementById('electricity'));
}


document.addEventListener('DOMContentLoaded', function() {
    navigator.getBattery().then((battery) => {
        init(battery);
        battery.addEventListener('levelchange', function () {
            console.log('电池电量发生变化');
            console.log('当前电量值：' + battery.level * 100);
            levelChange(battery);
        });
        battery.addEventListener('chargingchange', function () {
            console.log("充电状态发生变化");
            console.log(battery.charging);
            setStatus(battery.charging, battery.level);
        });


        function init(b) {
            setStatus(b.charging, b.level);
            setLevel(b.level);
        }


        function levelChange(b) {
            setStatus(b.charging, b.level);
            setLevel(b.level);
        }
    });
});
